function [param] = setParams()
% This function outputs the param structure, which contains initialized values 
% of the model parameters as well as derived steady-state values.

%% Households
param.beta        = 0.99;
param.theta_w     = 10;
param.sigma       = 1.5; 
param.phi_n       = 1;
param.b           = 0.5; 
param.xi_w        = 0.085; 
param.iota_w      = 0.2; 

%% Firms I
param.gamma_1     = 0.75;
param.iota_p      = 0.15; 
param.alpha       = 0.3;
param.theta_p     = 11;

%% Firms II
param.xi_I        = 2; 
param.xi_a        = 1;
param.delta       = 0.025;

%% Monetary Policy
param.phi_pi      = 1.5;
param.rho_i       = 0.7; 
param.phi_x       = 0.00; % changed (base: 0.05)
param.pi          = 1;

%% Fiscal Policy
param.by_ratio    = 4*0.2; 
param.rho         = 0.97; 
param.rho_tau     = 0.7; 
param.phi_taul     = 0.05;
param.phi_taux    = 0.00; % changed (base: 0.02)
param.gamma       = 1.004;
param.gy_ratio    = 0.2;

%% Autocorrelation of shocks
param.rho_gamma   = 0.2; 
param.rho_theta_w = 0.8; 
param.rho_theta_p = 0.8;
param.rho_g       = 0.8;
param.rho_xi      = 0.8;
param.rho_pistar  = 0.8; 
param.rho_m       = 0.8; 
param.rho_mu      = 0.8;
param.rho_tau_hat = 0.8; 
param.rho_obs     = 0.8;

%% Standard deviation of shocks
param.sigma_gamma    = 1;
param.sigma_theta_w  = 1;
param.sigma_theta_p  = 1;
param.sigma_g        = 1;
param.sigma_xi       = 1;
param.sigma_pistar   = 1;
param.sigma_m        = 1;
param.sigma_mu       = 1;
param.sigma_tau_hat  = 1;
param.sigma_obs      = 1;




%% Steady-state values
param.R              = param.beta^(-1) * param.gamma^(param.sigma);
param.P_m            = 1/(param.beta^(-1)*param.gamma^(param.sigma)-param.rho);
param.sy_ratio       = (param.beta^-1*param.gamma^(param.sigma-1)-1)*param.by_ratio;
param.R_K            = param.beta^(-1) * param.gamma^(param.sigma) - (1 - param.delta);
param.ik_ratio       = 1 - (1 - param.delta) * param.gamma^(-1);
param.S              = (param.theta_p - 1) / param.theta_p;
param.w_r            = (param.S * (1 - param.alpha)*(param.alpha/(1-param.alpha))^param.alpha / (param.R_K^param.alpha)) ^ (1/(1-param.alpha));
param.kN_ratio       = param.alpha/(1-param.alpha)*(param.w_r/param.R_K)*param.gamma;
param.yN_ratio       = param.gamma^(-param.alpha)*(param.kN_ratio)^(param.alpha)*param.S;
param.yk_ratio       = param.S*param.gamma^(-1)*((param.alpha/(1-param.alpha))*(param.w_r/param.R_K))^(param.alpha-1);
param.iy_ratio       = param.ik_ratio/param.yk_ratio;
param.ck_ratio       = (1-param.gy_ratio)*param.yk_ratio-param.ik_ratio; 
param.cy_ratio       = 1-param.ik_ratio/param.yk_ratio-param.gy_ratio;
param.wc_ratio       = (1-param.alpha)/param.alpha*(param.ck_ratio)^-1*(param.R_K/param.gamma);
param.xi_v           = (param.sigma-1)/(1-(param.gamma^-1)*param.b)*(param.theta_w-1)/param.theta_w * param.wc_ratio;
param.xi_vv          = param.phi_n^-1 +(param.sigma-1)/param.sigma*param.xi_v;
param.tauy_ratio     = param.sy_ratio+param.gy_ratio;
param.F_y_ratio      = (1-param.S)/param.S;    % set temporarily as zero; we need to figure out its inital value later
param.xi_p           = (1-param.gamma_1)*(1-param.gamma_1*param.beta*param.gamma^(1-param.sigma))*param.gamma_1^(-1);

% calculate some intermediate parameters
param.c_1w = -(param.xi_v - param.xi_vv)*param.theta_w + 1 + param.xi_w ^ (-1) + param.xi_w^(-1)*param.beta*param.gamma^(1-param.sigma);
param.c_2w = param.xi_w^(-1)*(1+param.beta*param.gamma^(1-param.sigma)*param.iota_w - param.xi_w*(1-param.b*param.gamma^(-1))^(-1));
param.c_3w = param.xi_v - param.xi_vv;


end

